<?php
namespace Codexpert\CoDesigner_Pro\App;
use Codexpert\Plugin\Base;
use Codexpert\CoDesigner_Pro\Helper;
/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * @package Plugin
 * @subpackage Installer
 * @author Codexpert <hi@codexpert.io>
 */
class Installer extends Base {

    public $plugin;
    public $slug;
    public $name;
    public $server;
    public $version;

	/**
	 * Constructor function
	 */
	public function __construct( $plugin ) {
		$this->plugin	= $plugin;
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->server	= $this->plugin['server'];
		$this->version	= $this->plugin['Version'];
	}
	/**
	 * Installer. Runs once when the plugin in activated.
	 *
	 * @since 3.17.2
	 */
	public function install() {
        if( ! get_option( "{$this->slug}_version" ) ){
			update_option( "{$this->slug}_version", $this->version );
		}
		
		if( ! get_option( "{$this->slug}_install_time" ) ){
			update_option( "{$this->slug}_install_time", date_i18n( 'U' ) );
		}
	}
	/**
	 * Uninstaller. Runs once when the plugin in deactivated.
	 *
	 * @since 3.17.2
	 */
	public function uninstall() {
		
		/**
		 * Remove scheduled hooks
		 */
		// wp_clear_scheduled_hook( 'codexpert-daily' );
	}
	public function update() {
		$new_version = $this->version;
		$old_version = get_option( "{$this->slug}_db-version" );

		if( $new_version == $old_version ) return;

		update_option( "{$this->slug}_db-version", $new_version, false );
        update_option( "{$this->slug}_update_time", date_i18n( 'U' ) );

        if( get_option( "{$this->slug}_install_time" ) == '' ) {
			update_option( "{$this->slug}_install_time", date_i18n( 'U' ) );
		}
		// upgrader actions
		do_action( "{$this->slug}_version-updated", $new_version, $old_version );
        //email designer module option name changed fix
        if ( get_option( 'wcd_email_designer' ) ) {
            $priv_data = get_option( 'wcd_email_designer' );
            update_option( 'codesigner_email_designer', $priv_data );
            delete_option( 'wcd_email_designer' );
        }
	}
}