<?php
namespace Codexpert\CoDesigner_Pro\Modules;
use Codexpert\CoDesigner\Helper;
use Codexpert\Plugin\Base;
use Elementor\Plugin as Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class Checkout_Builder extends Base {

    public $slug;
    public $version;
    public $id = 'codesigner-checkout-builder';

    /**
	 * Constructor
	 */
	public function __construct() {
        include_once( dirname( __FILE__ ) . '/inc/functions.php' );

		$this->plugin	= get_plugin_data( CODESIGNER );
		$this->slug		= $this->plugin['TextDomain'];
		$this->version	= $this->plugin['Version'];

        // register widget
		$this->action( 'elementor/widgets/register', 'register_widget' );

        //Ajax for add or remove product quentity
        $this->action( 'wp_ajax_checkout_template_quantity_add_or_remove', 'modify_product_quantity' ); 
        $this->action( 'wp_ajax_checkout_template_customize_quantity', 'customize_quantity' );

        // register scripts
		$this->action( 'wp_enqueue_scripts', 'enqueue_script' );
        $this->action( 'elementor/editor/after_enqueue_scripts', 'enqueue_script' );

        //Handle ajax
        $this->action( 'wp_ajax_codesigner_order_review_quantity_field', 'modify_product_quantity' );

    }
    public function customize_quantity() {
        $response = [
            'status'    => 0,
            'message'   => __( 'Unauthorized', 'codesigner-pro' ),
        ];

        if( ! wp_verify_nonce( $_POST[ 'nonce' ] , 'codesigner-pro' ) ) {
            wp_send_json( $response );
        }

        $product_id 		= $_POST['product_id'];
        $product_quantity 	= $_POST['quantity'];        

        foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			if ( $cart_item['product_id'] == $product_id ) {				
				WC()->cart->set_quantity( $cart_item_key, $product_quantity );
				break;
			}
		}

        $cart = WC()->cart;
        $cart->calculate_totals();
        $cart->calculate_shipping();

        //sub total
        $_subtotal  = $cart->subtotal_ex_tax;
        $subtotal   = wc_price( $_subtotal );
        //Total tax
        $cart_tax   = $cart->get_cart_contents_tax() + $cart->get_shipping_tax() + $cart->get_fee_tax();
        $cart_tax   = wc_price( $cart_tax );
        //sub total
        $_subtotal  = $cart->subtotal_ex_tax;
        $subtotal   = wc_price( $_subtotal );
        //Total tax
        $cart_tax   = $cart->get_cart_contents_tax() + $cart->get_shipping_tax() + $cart->get_fee_tax();
        $cart_tax   = wc_price( $cart_tax );
        //Total price
        $_total     = $cart->total;
        $total      = wc_price( $_total );

        wp_send_json_success([
            'subtotal'  => $subtotal,
            'tax'       => $cart_tax,
            'total'     => $total,
        ]);

        die();
    }


    public function modify_product_quantity() {

        $response = [
            'status'    => 0,
            'message'   => __( 'Unauthorized', 'codesigner-pro' ),
        ];

        if( ! wp_verify_nonce( $_POST['nonce'] , 'codesigner-pro') ) {
            wp_send_json( $response );
        }

        $product_id = $_POST['product_id'];
        $status 	= $_POST['addOrRamove'];        

        foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {

        	if ( 'remove' == $status ) {
	        	if ( $cart_item['product_id'] == $product_id ) {
	        		$product_quantity = $cart_item['quantity'];
					WC()->cart->set_quantity( $cart_item_key, $product_quantity-1 );
					break;
				}
	        }
	        elseif( 'add' == $status ){
				if ( $cart_item['product_id'] == $product_id ) {
					$product_quantity = $cart_item['quantity'];
					$product_quantity++;
					WC()->cart->set_quantity( $cart_item_key, $product_quantity );
					break;
				}
	        }
            
        }

        $cart = WC()->cart;

        $cart->calculate_totals();
        $cart->calculate_shipping();

        //sub total
        $_subtotal  = $cart->subtotal_ex_tax;
        $subtotal   = wc_price( $_subtotal );
        //Total tax
        $cart_tax   = $cart->get_cart_contents_tax() + $cart->get_shipping_tax() + $cart->get_fee_tax();
        $cart_tax   = wc_price( $cart_tax );
        //sub total
        $_subtotal  = $cart->subtotal_ex_tax;
        $subtotal   = wc_price( $_subtotal );
        //Total price
        $_total     = $cart->subtotal_ex_tax + $cart->get_cart_contents_tax() + $cart->get_shipping_tax() + $cart->get_fee_tax();
        $total      = wc_price( $_total );

        wp_send_json_success([
            'subtotal'         => $subtotal,
            'tax'              => $cart_tax,
            'total'            => $total
        ]);
        
        die();
    }

	public function register_widget( $widgets_manager ) {
		require_once( dirname( __FILE__ ) . '/widgets/checkout-builder-widget.php' );

		$widgets_manager->register( new \Checkout_Builder_Widget() );
	}

	public function enqueue_script() {
        $files  = codesigner_get_checkout_templates_list();

        wp_enqueue_style('chosen-css', 'https://cdn.jsdelivr.net/npm/chosen-js@1.8.7/chosen.min.css');

        // Enqueue Chosen JavaScript from CDN
        wp_enqueue_script('chosen', 'https://cdn.jsdelivr.net/npm/chosen-js@1.8.7/chosen.jquery.min.js', array('jquery'), '1.8.7', true);

        foreach ( $files as $file ) {
            wp_enqueue_style( 'cd-checkout-builder-'. $file, plugins_url( 'assets/css/'. $file . '.css', __FILE__ ), '', $this->version, 'all' );

            wp_enqueue_script( 'cd-checkout-builder-'. $file, plugins_url( 'assets/js/'. $file . '.js', __FILE__ ), '', $this->version, 'all' );
        }

		wp_enqueue_media();
	}
}