<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];

$widget->start_controls_section(
    'progress_temp3_text',
    [
        'label'      => __( 'Heading Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);
$widget->add_control(
    'progress_temp3_show_hide',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);
$widget->add_control(
    'temp-3-billing-heading',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-3-ship-to-text',
    [
        'label'         => __( 'Ship To Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Ship to a different address?', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-3-shipping-heading',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-3-order-notes',
    [
        'label'         => __( 'Order Notes', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Notes(optional)', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-3-billing-summary-heading',
    [
        'label'         => __( 'Order Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);

$widget->add_control(
    'temp-payment-methods-input',
    [
        'label'         => __( 'Payment Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_temp3_order_btn_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);
$widget->add_control(
    'order_btn_txt_temp3',
    [
        'label'         => __( 'Order Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Place Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();
/**
 * Billing & shipping address
 */
$widget->start_controls_section(
    'cd_billing_temp_3',
    [
        'label'      => __( 'Billing & Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

$widget->add_control(
    'cd_billing_temp3_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .billing-address-wrap' => 'background: {{VALUE}}',
            '{{WRAPPER}} .temp-3 .shipping-address-wrap' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_temp_3_billing_and_shipping_border_and_heading'
);

$widget->start_controls_tab(
    'cd_temp_3_billing_shipping_heading',
    [
        'label' => esc_html__( 'Heading', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_billing_temp3_heading_typrography',
        'selector'  => '{{WRAPPER}} .temp-3 .billing-address-wrap h3, .temp-3 .shipping-address-wrap h3',
    ] 
);
$widget->add_control(
    'cd_billing_temp3_heading_color',
    [
        'label'     => esc_html__( 'Heading', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .billing-address-wrap h3, .temp-3 .shipping-address-wrap h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_temp_3_billing_shipping_border',
    [
        'label' => esc_html__( 'Border', 'codesigner-pro' ),
    ]
);
$widget->add_control(
    'cd_billing_temp3_shipping_border_color',
    [
        'label'     => esc_html__( 'Border', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .billing-address-wrap, {{WRAPPER}} .temp-3 .shipping-address-wrap' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_temp3_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .temp-3 .billing-address-wrap, {{WRAPPER}} .temp-3 .shipping-address-wrap ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();

$widget->end_controls_section();

//Billing and shipping form input
$widget->start_controls_section(
    'cd_billing_and_shipping_form_input_temp_3',
    [
        'label'      => __( 'Billing & Shipping Input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

//start billing and shipping label and input tab
$widget->start_controls_tabs(
    'cd_temp_3_billing_and_shipping_form'
);

$widget->start_controls_tab(
    'cd_temp_3_billing_label',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_billing_temp3_input_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesigner-left-area .form-row label' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_temp3_input_label_background_color',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesigner-left-area .form-row label' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_billing_temp3_input_label_trypography_codesigner',
        'selector'  => '{{WRAPPER}} .temp-3 .codesigner-left-area .form-row label'
    ]
);

$widget->add_responsive_control(
    'cd_billing_and_shopping_label_offset_left',
    [
        'label' 		=> __( 'Offset Left', 'codesigner' ),
        'type' 			=> Controls_Manager::SLIDER,
        'size_units' 	=> ['px'],
        'range' 		=> [
            'px' 		=> [
                'min' 	=> -1000,
                'max' 	=> 1000,
            ],
        ],
        'selectors'     => [
            '.wl {{WRAPPER}} .temp-3 .form-row label' => 'left: {{SIZE}}{{UNIT}}',
        ],
        'render_type' 	=> 'ui',
    ]
);

$widget->add_responsive_control(
    'cd_billing_and_shopping_label_offset_top',
    [
        'label' 		=> __( 'Offset Top', 'codesigner' ),
        'type' 			=> Controls_Manager::SLIDER,
        'size_units' 	=> ['px'],
        'range' 		=> [
            'px' 		=> [
                'min' 	=> -1000,
                'max' 	=> 1000,
            ],
        ],
        'selectors' 	=> [
            '.wl {{WRAPPER}} .temp-3 .form-row label' => 'top: {{SIZE}}{{UNIT}}'
        ],
        'default' => [
            'unit' => 'px',
            'size' => -7,
        ]
    ]
);

$widget->end_controls_tab();


$widget->start_controls_tab(
    'cd_temp_3_billing_input',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_billing_temp3_input_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .form-row input.input-text, #shipping_country, #shipping_state,.select2-selection__rendered, .form-row select' => 'color: {{VALUE}} ! important',
        ],
    ]
);
$widget->add_control(
    'cd_billing_temp3_input_border_color',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .form-row input.input-text' => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .temp-3 .select2-container--default .select2-selection--single' => 'border-color: {{VALUE}}'
        ],
    ]
);
$widget->add_control(
    'cd_billing_temp3_input_background_color',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .form-row input.input-text' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .temp-3 span.select2.select2-container.select2-container--default' => 'background-color: {{VALUE}}',
            
        ],
    ]
);
$widget->add_responsive_control(
    'cd_billing_temp3_input_tt_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .form-row input.input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_billing_temp3_input_tt_margin',
    [
        'label' 		=> esc_html__( 'Margin', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .form-row input.input-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_control(
    'cd_billing_temp3_input_tt_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .form-row input.input-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();

$widget->end_controls_section();


$widget->start_controls_section(
    'temp_3_ship_to_different',
    [
        'label'      => __( 'Ship to different input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'temp_3_ship_to_different_typography',
        'selector'  => '{{WRAPPER}} .temp-3 #ship-to-different-address span',
    ]
);
$widget->add_control(
    'temp_3_ship_to_different_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 #ship-to-different-address span' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

/**
 * Billing & shipping address
 */
$widget->start_controls_section(
    'cd_billing_summary_temp_3',
    [
        'label'      => __( 'Billing summary', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_background_color_temp_3',
    [
        'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesinger-cart-item-wrap' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_border_color_temp_3',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesinger-cart-item-wrap' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_billing_summary_padding_temp_3',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .codesinger-cart-item-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_border-radius_temp_3',
    [
        'label' 		=> esc_html__( 'Border radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .codesinger-cart-item-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_heading_color_temp_3',
    [
        'label'     => esc_html__( 'Heading Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesinger-cart-item-wrap h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_after_heading_border_color_temp_3',
    [
        'label'     => esc_html__( 'Heading Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesinger-cart-item-wrap h3' => 'border-color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_section();

/**
 * Billing summray Products
 */
$widget->start_controls_section(
    'cd_billing_summary_temp_3_product',
    [
        'label'      => __( 'Billing summary Products', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

//start billing and shipping label and input tab
$widget->start_controls_tabs(
    'cd_temp_3_billing_billing_summary_products'
);

$widget->start_controls_tab(
    'cd_temp_3_billing_summeru_product',
    [
        'label' => esc_html__( 'Product Info', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_billing_summary_product_title_color_temp_3',
    [
        'label'     => esc_html__( 'Title', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-product-title' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_temp3_product_title_typography',
        'selector'  => '{{WRAPPER}} .codesigner-product-title',
    ]
);

$widget->add_control(
    'cd_billing_summary_price_color_temp_3',
    [
        'label'     => esc_html__( 'Price', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesinger-cart-item-price bdi' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_cross_icon_temp_3',
    [
        'label'     => esc_html__( 'Cross Icon', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} a.remove .ahfb-svg-iconset' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_tab();

//Product Quantity tab 
$widget->start_controls_tab(
    'cd_temp_3_billing_summeru_product_qunatity',
    [
        'label' => esc_html__( 'Quantity Field', 'codesigner-pro' ),
    ]
);
$widget->add_control(
    'cd_billing_summary_quantity_text_color_temp_3',
    [
        'label'     => esc_html__( 'Text', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty input[type=number]' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_quantity_text_background_color_temp_3',
    [
        'label'     => esc_html__( 'Qunatity Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty input[type=number]' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_quantity_color_temp_3',
    [
        'label'     => esc_html__( 'Button', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty .qty-btn' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_quantity_border_color_temp_3',
    [
        'label'     => esc_html__( 'Border', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty .qty-btn' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_quantity_bg_color_temp_3',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty .qty-btn' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();

$widget->end_controls_section();

/**
 * Price table Constrols
 */
$widget->start_controls_section(
    'cd_billing_summary_temp_3_product_price_table',
    [
        'label'      => __( 'Price Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_temp_3_billing_summary_total_price'
);
$widget->start_controls_tab(
    'cd_temp_3_billing_summary_total_price_table',
    [
        'label' => esc_html__( 'Price Table', 'codesigner-pro' ),
    ]
);
$widget->add_control(
    'temp-3-total-price',
    [
        'label'         => __( 'Total', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Total', 'codesigner' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_price_table_order_review_table_typography',
        'selector'  => '{{WRAPPER}} .shop_table tfoot tr th , {{WRAPPER}} .shop_table tfoot tr td .woocommerce-Price-amount.amount bdi , {{WRAPPER}} .shop_table tfoot tr td .woocommerce-Price-amount.amount',
    ]
);
$widget->add_control(
    'cd_billing_summary_total_price_total_border_color_bottom_temp_3',
    [
        'label'     => esc_html__( 'Border', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .shop_table tfoot tr:last-child th, .woocommerce.woocommerce-checkout table.shop_table td' => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .shop_table tfoot tr:first-child th, .woocommerce.woocommerce-checkout table.shop_table td' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_billing_summary_total_price_table_padding_temp_3',
    [
        'label' 		=> esc_html__( 'Table Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .codesigner-price-table tfoot tr th, .codesigner-price-table tfoot tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();

//sub total tab
$widget->start_controls_tab(
    'cd_temp_3_billing_summary_total_price_',
    [
        'label' => esc_html__( 'Sub Total', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_billing_summary_total_price_table_h_color_temp_3',
    [
        'label'     => esc_html__( 'Label', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .shop_table tfoot tr th' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_billing_summary_total_price_table_p_color_temp_3',
    [
        'label'     => esc_html__( 'Price', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .shop_table tfoot tr td .woocommerce-Price-amount.amount bdi' => 'color: {{VALUE}}',
            '{{WRAPPER}} .shop_table tfoot tr td .woocommerce-Price-amount.amount' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

//Total price tab
$widget->start_controls_tab(
    'cd_temp_3_billing_summary_total_price__',
    [
        'label' => esc_html__( 'Total Price', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_billing_summary_total_price_total_heading_clr_temp_3',
    [
        'label'     => esc_html__( 'Total Price Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .shop_table tfoot tr:last-child th' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_billing_summary_total_price_total_price_clr_temp_3',
    [
        'label'     => esc_html__( 'Total Price', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .shop_table tfoot tr:last-child td .woocommerce-Price-amount.amount bdi' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();

$widget->end_controls_section();

/**
 * Payment method
 */
$widget->start_controls_section(
    'cd_paymenthod_method_temp_3',
    [
        'label'      => __( 'Payment Method', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);
$widget->add_control(
    'cd_temp_3_payment_bg',
    [
        'label'     => esc_html__( 'Background Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-payment-method-wrap' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_temp_3_payment_border_clr',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-payment-method-wrap' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_payment_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .codesigner-payment-method-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_temp_3_payment_form'
);
$widget->start_controls_tab(
    'cd_temp_3_payment_container',
    [
        'label' => esc_html__( 'Container', 'codesigner-pro' ),
    ]
);
$widget->add_control(
    'cd_temp_3_payment_heading_clr',
    [
        'label'     => esc_html__( 'Heading', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-payment-method-wrap h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_codesigner_payment_method_typography',
        'selector'  => '{{WRAPPER}} .codesigner-payment-method-wrap h3',
    ]
);
$widget->add_control(
    'cd_temp_3_payment_container_background_clr',
    [
        'label'     => esc_html__( 'Container Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-payment-method-container' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_temp_3_payment_item',
    [
        'label' => esc_html__( 'Method', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_temp_3_payment_method_title',
    [
        'label'     => esc_html__( 'Method Title', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} ul.payment_methods li' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_temp_3_payment_method_title_description_clr',
    [
        'label'     => esc_html__( 'Method Description', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} div.payment_box p:last-child' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_temp_3_payment_method_title_desc_typography',
        'selectors'  => [
            '{{WRAPPER}} ul.payment_methods li',
            '{{WRAPPER}} div.payment_box p:last-child',
        ]
    ]
);
$widget->add_control(
    'cd_temp_3_payment_method_title_description_bg_clr',
    [
        'label'     => esc_html__( 'Description Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment div.payment_box' => 'background: {{VALUE}}',
            '{{WRAPPER}} #payment div.payment_box::before' => 'border-bottom-color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();

$widget->end_controls_section();

/**
 * Terms and condition
 */
$widget->start_controls_section(
    'cd_paymenthod_method_temp_3_terms_and_condition',
    [
        'label'      => __( 'Terms and Conditions', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_terms_and_condition_typography',
        'selector'  => '{{WRAPPER}} .temp-3 .form-row label .woocommerce-terms-and-conditions-checkbox-text',
    ]
);

$widget->add_control(
    'cd_temp_3_termns_and_conditon_check_box',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .form-row label .woocommerce-terms-and-conditions-checkbox-text' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_temp_3_termns_and_conditon_check_box_anchor',
    [
        'label'     => esc_html__( 'Anchor Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .form-row label .woocommerce-terms-and-conditions-checkbox-text a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_termns_and_conditon_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .temp-3 .woocommerce-terms-and-conditions-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_termns_and_conditon_margin',
    [
        'label' 		=> esc_html__( 'Margin', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .temp-3 .woocommerce-terms-and-conditions-wrapper .form-row' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tabs();

$widget->end_controls_section();


/**
 * Pay order button
 */
$widget->start_controls_section(
    'temp-3-order-button',
    [
        'label'      => __( 'Pay Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

$widget->add_control(
    'cd_temp_3_payment_button_clr',
    [
        'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment #place_order' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_temp_3_payment_button_bg_clr',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment #place_order' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_payment_btn_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} #payment #place_order' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_payment_btn_margin',
    [
        'label' 		=> esc_html__( 'Margin', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} #payment #place_order' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_temp_3_payment_btn_box_shadow',
    [
        'label' 		=> esc_html__( 'Box shadow', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} #payment #place_order' => 'box-shadow: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_section();


/**
 * Order Note
 */
$widget->start_controls_section(
    'temp-3-order-note',
    [
        'label'      => __( 'Order Note', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-3',
        ],
    ]
);

$widget->start_controls_tabs(
    'order-note-textarea-label-temp-3'
);

$widget->start_controls_tab(
    'order-note-temp-3-label',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'temp-3-order-note-lable-color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .notes label' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'temp-3-order-note-label-bg',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .notes label' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'temp-3-order-note-label-typo',
        'selector'  => '{{WRAPPER}} .temp-3 .codesinger-order-note .notes label'
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'order-note-temp-3-textarea',
    [
        'label' => esc_html__( 'Textarea', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'temp-3-order-note-textarea-color_',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .codesigner-order-textarea' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'temp-3-order-note-textarea-bg',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .codesigner-order-textarea' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'temp-3-order-note-textarea-color',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .codesigner-order-textarea' => 'border-color: {{VALUE}}',
        ],
    ]
);

$widget->add_responsive_control(
    'temp-3-order-note-textarea-padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .codesigner-order-textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'temp-3-order-note-textarea-border-radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .temp-3 .codesinger-order-note .codesigner-order-textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
    ]
);




$widget->end_controls_tab();

$widget->end_controls_tabs();




$widget->end_controls_section();
