<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];

$widget->start_controls_section(
    'progress_temp6_text',
    [
        'label'      => __( 'Heading Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_control(
    'progress_temp6_show_hide',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);

$widget->add_control(
    'billing_address_txt_temp6',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp6_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'ship_to_different_temp6',
    [
        'label'         => __( 'Ship To Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Ship to a different address?', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp6_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'shipping_address_txt_temp6',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp6_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-6-order-notes',
    [
        'label'         => __( 'Order Notes', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Notes(optional)', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'payment_txt_temp6_',
    [
        'label'         => __( 'Payment Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp6_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'order_txt_temp6',
    [
        'label'         => __( 'Order Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp6_show_hide' => 'yes'
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp6_order_btn_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_control(
    'order_btn_txt_temp6',
    [
        'label'         => __( 'Order Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Place Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6',
    [
        'label'      => __( 'Checkout Left Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_control(
    'cd_checkout-template6-background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container'     => 'background: {{VALUE}} ',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields label'  => 'background: {{VALUE}} ',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields label' => 'background: {{VALUE}} '
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_section_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container #cd-billing'  => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container #cd-shipping' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template6_coupon_form',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template6_coupon_form_control'
);
$widget->start_controls_tab(
    'cd_checkout_template6_coupon_form_text_tab',
    [
        'label' => esc_html__( 'Text', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_coupon_form_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form .woocommerce-info,
                        {{WRAPPER}} #cd-coupon-main p ',
    ]
);
$widget->add_control(
    'cd_checkout_template6_coupon_form_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form .woocommerce-info' => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main p'                 => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_coupon_form_input_color',
    [
        'label' 	=> esc_html__( 'Input Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input::placeholder' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_coupon_form_input_bg',
    [
        'label' 	=> esc_html__( 'Input background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_coupon_form_input_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Input Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template6_coupon_form_button_tab',
    [
        'label' => esc_html__( 'Button', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_coupon_form_button_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form a.showcoupon,
                        {{WRAPPER}} #cd-coupon-main .form-row-last button',
    ]
);
$widget->add_control(
    'cd_checkout_template6_coupon_form_button_color',
    [
        'label' 	=> esc_html__( 'Button Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon'           => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_coupon_form_button_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon'           => 'background: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_coupon_form_button_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-form a.showcoupon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_billing_heading',
    [
        'label'      => __( 'Checkout Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container h3',
    ]
);
$widget->add_control(
    'cd_checkout_template6_heading_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_billing_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .title' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_billing_form_style',
    [
        'label'      => __( 'Billing & Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template6_billing_form_design'
);
$widget->start_controls_tab(
    'cd_checkout_template6_form_message_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'cd_checkout_template6_form_message_typography',
        'selector'   => '{{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields label,
                         {{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields label'     
    ]
);
$widget->add_control(
    'cd_checkout_template6_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' {{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields label'    => 'color: {{VALUE}};' ,
            ' {{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields label'   => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template6_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_form_input_typography',
        'selector'  => '{{WRAPPER}} .woocommerce-input-wrapper input,
                        {{WRAPPER}} .woocommerce-input-wrapper select,
                        {{WRAPPER}} .woocommerce-input-wrapper select .select2-selection'

    ]
);
$widget->add_control(
    'cd_checkout_template6_form_input_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper input input:focus' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_form_row_border',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields .form-row'   => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields .form-row'  => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_form_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields input'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-billing-fields select'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-shipping-fields select'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

        
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section (
    'cd_checkout_template6_order_notes_label',
    [
        'label'      => __( 'Order Notes', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_template6_order_notes_form_design'
);
$widget->start_controls_tab(
    'cd_checkout_template6_order_notes_label_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'cd_checkout_template6_order_notes_typography',
        'selector'   => '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row label '     
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_notes_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row label' => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template6_order_notes_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_order_notes_input_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row textarea'

    ]
);
$widget->add_control(
    'cd_checkout_template6_order_notes_input_color_placeholder',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row textarea::placeholder'   => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_notes_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes'                    => 'background: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row label'    => 'background: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row textarea' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_notes_input_border',
    [
        'label'     => esc_html__( 'Border Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes'            => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes .form-row'  => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_order_notes_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-notes '   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_ship_to_different',
    [
        'label'      => __( 'Ship to different input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_ship_to_different_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 .cd-enable-shipping label',
    ]
);
$widget->add_control(
    'cd_checkout_template6_ship_to_different_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-enable-shipping label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_payment_section',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_payment_section_border_color',
    [
        'label' 	=> esc_html__( 'Section Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .cd-address-container #cd-temp-6-payment' => 'border-color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_table_payment_section_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 .title',
    ]
);
$widget->add_control(
    'payment_txt_temp6',
    [
        'label'         => __( 'Payment Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'cd_checkout_template6_payment_section_heading_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .title' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_payment_section_text_border_color',
    [
        'label' 	=> esc_html__( 'Text Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .title' => 'border-color: {{VALUE}} ',
        ],
    ]
);
$widget->start_controls_tabs (
    'cd_checkout_template6_payment_section_order_style_tabs'
);
$widget->start_controls_tab(
    'cd_checkout_template6_payment_section_Label',
    [
        'label' 	=> esc_html__( 'Header', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_table_payment_section_header_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 #cd-temp-6-payment ul li label',
    ]
);
$widget->add_control(
    'cd_checkout_template6_payment_section_border_header_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-temp-6-payment ul li label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_payment_section_heading_bg_color',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-temp-6-payment .wc_payment_method' => 'background : {{VALUE}} !important ',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'cd_checkout_template6_payment_section_description',
    [
        'label' 	=> esc_html__( 'Box', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_table_payment_section_wrapper_description_typography',
        'selector'  => '{{WRAPPER}} .wc_payment_method .payment_method_bacs p ,
                        {{WRAPPER}} .wc_payment_method .payment_method_cod p',
    ]
);
$widget->add_control(
    'cd_checkout_template6_table_payment_section_description_color',
    [
        'label'     => esc_html__( 'Box Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .wc_payment_method p ' => 'color: {{VALUE}}',
            '{{WRAPPER}} .wc_payment_method p '  => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_table_payment_section_description_background',
    [
        'label' 	=> esc_html__( 'Box Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment #cd-payment-description'   => 'background: {{VALUE}} ',
            '{{WRAPPER}} #payment div.payment_box::before'   => 'border-bottom-color: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_order_payment_section_box_border_radius',
    [
        'label'     => esc_html__( 'Box Border Radius', 'codesigner-pro' ),
        'type'      => Controls_Manager::DIMENSIONS,
        'size_units'=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' => [
            '{{WRAPPER}} #payment #cd-payment-description ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_order_details_design',
    [
        'label'      => __( 'Order Details Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_details_bg',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery ' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_details_border',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery ' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_order_details_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery '  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_product_details_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Table Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->start_controls_tabs (
    'cd_checkout_template6_details_order_style_tabs'
);
$widget->start_controls_tab(
    'cd_checkout_template6_order_details_heading',
    [
        'label' 	=> esc_html__( 'Table Heading', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_table_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery .cd-temp-6-order-title',
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_details_heading_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery .cd-temp-6-order-title ' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_details_heading_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-order-summery .title ' => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-product-list'          => 'border-color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 .woocommerce-checkout-review-order-table .order-total th' => 'border-color: {{VALUE}} !important',
            '{{WRAPPER}}  .cd-checkout-temp-6 .woocommerce-checkout-review-order-table .order-total td' => 'border-color: {{VALUE}} !important'
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_template6_order_details_body',
    [
        'label' 	=> esc_html__( 'Table Body', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_table_order_details_body_typography',
        'selectors' => '{{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_title p,
                       {{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_quantity p,
                       {{WRAPPER}} #cd-checkout-order-id .cd_checkout_product_price p,
                       {{WRAPPER}} #cd-checkout-order-id .cart-subtotal,
                       {{WRAPPER}} #cd-checkout-order-id .order-total,
                       {{WRAPPER}} .cd-order-table-product span',
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_details_body_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-product-list .cd-product-details p'                       => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-product-list .cd-product-details a'                       => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-product-list  p.cd-product-price bdi'                     => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-checkout-tfoot-wrap tfoot tr th'      => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-checkout-tfoot-wrap tfoot tr td'      => 'color: {{VALUE}}',
            '{{WRAPPER}} .cd-checkout-temp-6 #cd-checkout-tfoot-wrap tfoot tr td bdi'  => 'color: {{VALUE}}',
    ]
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_table_body_image_control',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} #cd-product-list .cd-product-image img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_product_image_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Image Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-product-list .cd-product-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template6_Order_button',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_order_button_background_typography',
        'selector'  => '{{WRAPPER}} button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_button_background',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order ' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'cd_checkout_template6_order_button_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} button#place_order' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_template6_order_button_box_shadow',
        'selector' 	=> '{{WRAPPER}} button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_template6_order_button_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template6_terms_and_policy',
    [
        'label'      => __( 'Terms and Policy', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-6',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template6_terms_and_policy_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-temp-6 .woocommerce-terms-and-conditions-checkbox-text',
    ]
);
$widget->add_control(
    'cd_checkout_template6_terms_and_policy_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .woocommerce-terms-and-conditions-checkbox-text ' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_template6_terms_and_policy_linkcolor',
    [
        'label'     => esc_html__( 'Link Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-temp-6 .woocommerce-terms-and-conditions-checkbox-text a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();