<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];
$placeholders   = [ '%%user_name%%', '%%website_link%%', '%%admin_name%%' ];


$widget->start_controls_section(
    'order_new_account_heading',
    [
        'label'      => __( 'Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);

$widget->add_control(
    'new_account_heading_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_heading_txt_new_account',
    [
        'label'         => __( 'Heading Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Welcome to %%website_link%%', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_new_account_body',
    [
        'label'      => __( 'Body', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);

$widget->add_control(
    'new_account_body_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_sub_txt_new_account',
    [
        'label'         => __( 'Sub Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXTAREA,
        'rows'          => 5,
        'default'       => __( 'Hi %%user_name%%, I am %%admin_name%% Thanks for creating an account on %%website_link%%. Your username is %%user_name%%. you can access your account area to view orders, change your password and more at %%website_link%%<a>/my-account/</a>' , 'codesigner-pro' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'link_text_new',
    [
        'label'         => __( 'Link Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( "Click here to set your new password", 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'user_section_user_head_msg_text_new',
    [
        'label'         => __( 'Notice Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( "We look forward to seeing you soon", 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();


$widget->start_controls_section(
    'new_order_new_',
    [
        'label'      => __( 'Background', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_color_new',
    [
        'label' 	=> esc_html__( 'Section Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .cd-no-border' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_color_new_table',
    [
        'label' 	=> esc_html__( 'Table Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .cd-email-center' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_heading_new_customer',
    [
        'label'      => __( 'Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_heading_typography_new',
        'selector'  => '{{WRAPPER}} #cd-customer-new-account .codesigner-email-header h3',
    ]
);
$widget->add_control(
    'new_order_heading_color_new',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .codesigner-email-header h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_heading_bg_color_new',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .codesigner-email-header' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_message_new',
    [
        'label'      => __( 'Table Order Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_order_message_typography_new',
        'selector'  => '{{WRAPPER}} #cd-customer-new-account .codesigner-new_account-password-message p,
                        {{WRAPPER}} #cd-customer-new-account .codesigner-new_account-password-message p a',
    ]
);
$widget->add_control(
    'table_order_message_text_color_new',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .codesigner-new_account-password-message p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-new-account .codesigner-new_account-password-message p a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'table_order_message_border_color_new',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .codesigner-new_account-password-message' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'user_section_new',
    [
        'label'      => __( 'new_account Link', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'user_section_user_head_link_typography_new',
        'selector'  => '{{WRAPPER}} #cd-customer-new-account .cd-new_account-password a',
    ]
);
$widget->add_control(
    'user_section_user_head_link_color_new',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .cd-new_account-password a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();


$widget->start_controls_section(
    'before_footer_msg_new',
    [
        'label'      => __( 'Footer Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-new-account',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'before_footer_msg_typography_new',
        'selector'  => '{{WRAPPER}} #cd-customer-new-account .cd-before-footer-message p ,
                        {{WRAPPER}} #cd-customer-new-account .cd-before-footer-message p a',
    ]
);
$widget->add_control(
    'before_footer_msg_color_new',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-new-account .cd-before-footer-message p' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();