<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];
$placeholders   = [ '%%order_id%%', '%%user_name%%', '%%status%%', '%%date%%', '%%website_link%%', '%%order_notes%%', '%%admin_name%%' ];

$widget->start_controls_section(
    'order_refunded_heading',
    [
        'label'      => __( 'Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);

$widget->add_control(
    'refunded_heading_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_heading_txt_refunded',
    [
        'label'         => __( 'Heading Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order %%status%% #%%order_id%%', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_refunded_body',
    [
        'label'      => __( 'Body', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);

$widget->add_control(
    'refunded_body_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_sub_txt_refunded',
    [
        'label'         => __( 'Sub Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXTAREA,
        'rows'          => 5,
        'default'       => __( 'Hi %%user_name%%, Your order on %%website_link%% has been %%status%%.There are more details below for your reference.' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'table_heading_txt_refunded',
    [
        'label'         => __( 'Table Heading', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order #%%order_id%% (%%date%%)' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'product_billing_txt_refunded',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Address', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'product_shipping_txt_refunded',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Address', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'thanks_txt_refunded',
    [
        'label'         => __( 'Thanks Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'We hope to see you again soon', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_refunded_footer',
    [
        'label'      => __( 'Footer', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);

$widget->add_control(
    'refunded_footer_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);


$widget->add_control(
    'footer_refunded_text',
    [
        'label'         => __( 'Footer Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( '%%website_link%% - Build with CoDesigner', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_refunded',
    [
        'label'      => __( 'Background', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_color_refunded',
    [
        'label' 	=> esc_html__( 'Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-no-border' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_color_table_refunded',
    [
        'label' 	=> esc_html__( 'Table Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-email-center' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'new_order_heading_refunded',
    [
        'label'      => __( 'Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_heading_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-email-header h3',
    ]
);
$widget->add_control(
    'new_order_heading_color_refunded',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-email-header h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_heading_bg_color_refunded',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-email-header' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_message_refunded',
    [
        'label'      => __( 'Table Order Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_order_message_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-order-proccessiong-message p,
                        {{WRAPPER}} #cd-customer-refunded-order  .cd_site_url',
    ]
);
$widget->add_control(
    'table_order_message_text_color_refunded',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-order-proccessiong-message p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-refunded-order  .cd_site_url' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'table_order_message_border_color_refunded',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-order-proccessiong-message' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'product_table_heading_refunded',
    [
        'label'      => __( 'Product Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_heading_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-order-date h4',
    ]
);
$widget->add_control(
    'product_table_heading_color_refunded',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-order-date h4' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'product_table_refunded',
    [
        'label'      => __( 'Product Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
); 
$widget->start_controls_tabs(
    'product_table_section_refunded'
);
$widget->start_controls_tab(
    'product_table_head_refunded',
    [
        'label' => esc_html__( 'Header', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_header_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table th',
    ]
);
$widget->add_control(
    'product_table_header_color_refunded',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table th' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_header_background_refunded',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table thead' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'product_table_products_refunded',
    [
        'label' => esc_html__( 'Products', 'codesigner-pro' ),
    ]
);
$widget->add_responsive_control(
    'product_table_image_control_refunded',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 64,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_products_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td span ,
                        {{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td',
    ]
);
$widget->add_control(
    'product_table_products_color_refunded',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td span' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_products_background_refunded',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_products_border_color_refunded',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-product-table tbody tr td' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();


$widget->start_controls_tab(
    'product_table_footer_refunded',
    [
        'label' => esc_html__( 'Footer', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_footer_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .codesigner-item-price-table tbody tr td:last-child,
                        {{WRAPPER}} #cd-customer-refunded-order .codesigner-item-price-table tbody tr td:first-child',
    ]
);
$widget->add_control(
    'product_table_footer_color_refunded',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-item-price-table tbody tr td:last-child' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-item-price-table tbody tr td:first-child' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_footer_border_color_refunded',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .codesigner-item-price-table tbody tr td' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'billing_and_shipping_address_refunded',
    [
        'label'      => __( 'Billing & Shipping Address', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
); 
$widget->start_controls_tabs(
    'billing_and_shipping_table_section_refunded'
);
$widget->start_controls_tab(
    'billing_shipping_table_header_refunded',
    [
        'label' => esc_html__( 'Header', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'billing_shipping_header_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table thead tr th',
    ]
);
$widget->add_control(
    'billing_shipping_header_color_refunded',
    [
        'label' 	=> esc_html__( 'Header Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table thead tr th' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'billing_shipping_table_body_refunded',
    [
        'label' => esc_html__( 'Body', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'billing_shipping_body_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table tbody tr td',
    ]
);
$widget->add_control(
    'billing_shipping_body_color_refunded',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table tbody tr td' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'billing_shipping_body_bg_refunded',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table tbody tr td' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'billing_shipping_body_border_radius_refunded',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-shipping-billing-table tbody tr td' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'before_footer_msg_refunded',
    [
        'label'      => __( 'Footer Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'before_footer_msg_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .cd-before-footer-message p ,
                        {{WRAPPER}} #cd-customer-refunded-order .cd-before-footer-message p a',
    ]
);
$widget->add_control(
    'before_footer_msg_color_refunded',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-before-footer-message p' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'footer_btn_refunded',
    [
        'label'      => __( 'Footer Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-refunded-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'footer_msg_typography_refunded',
        'selector'  => '{{WRAPPER}} #cd-customer-refunded-order .cd-link-area p',
    ]
);
$widget->add_control(
    'footer_msg_color_refunded',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-link-area p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-refunded-order .cd-link-area p a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'footer_msg_background_refunded',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-refunded-order .cd-link-area' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();