<?php

$settings                   = $args['settings'];
$order_id                   = $args['order_id'];
$order 	                    = wc_get_order( $order_id );
$user_id                    = $order->get_user_id();
$user_info                  = get_userdata( $user_id );
$ordered_user_name          = $user_info->display_name;
$order_date                 = $order->get_date_created();
$formatted_order_date       = $order_date->date( 'F j, Y' );
$order_status               = $order->get_status();
$admin_email                = get_option('admin_email');
$admin_user                 = get_user_by('email', $admin_email);
$param                      = [];
$param['order_id']          = $order_id;
$param['user_name']         = $ordered_user_name;
$param['status']            = $order_status;
$param['date']              = $formatted_order_date;
$param['order_notes']       = $order->get_customer_note();
$param['admin_name']        = $admin_user->user_login;
$order_txt_failed           = apply_filters( 'codesigner_email_replace_placeholders', $settings['order_heading_txt_failed'], $param );
$order_sub_txt_failed       = apply_filters( 'codesigner_email_replace_placeholders', $settings['order_sub_txt_failed'], $param );
$table_heading_txt_failed   = apply_filters( 'codesigner_email_replace_placeholders', $settings['table_heading_txt_failed'], $param );
$billing_txt                = apply_filters( 'codesigner_email_replace_placeholders', $settings['product_billing_txt_failed'], $param );
$shipping_txt               = apply_filters( 'codesigner_email_replace_placeholders', $settings['product_shipping_txt_failed'], $param );
$thanks_txt_failed          = apply_filters( 'codesigner_email_replace_placeholders', $settings['thanks_txt_failed'], $param );
$footer_failed_text         = apply_filters( 'codesigner_email_replace_placeholders', $settings['footer_failed_text'], $args );
$items                      = $order->get_items();
$subtotal                   = $order->get_subtotal();
$shipping_total             = $order->get_shipping_total();
$tax_total                  = $order->get_total_tax();
$total                      = $order->get_total();
$payment_method             = $order->get_payment_method();
$formatted_billing_address  = $order->get_formatted_billing_address();
$formatted_shipping_address = $order->get_formatted_shipping_address();
$shipping_email             = $order->get_billing_email();
$billing_email              = $order->get_billing_email();
$fees                       = $order->get_fees();
$discount                   = $order->get_discount_total();
?>
<div class='codesigner-email-wrapper'>
    <table class="codesigner-email-template">
        <tbody class="cd-email-bg" id="cd-admin-failed-order">
            <tr>
                <td class="cd-no-border cd-deafult-bg"></td>
                <td class="cd-email-center cd-no-border">
                    <div class="codesigner-email-header">
                        <h3 class="codesigner-order-id"><?php echo wp_kses_post( $order_txt_failed ); ?></h3>
                    </div>
                    <div class="codesigner-order-cancelled-message">
                        <p> <?php echo wp_kses_post( $order_sub_txt_failed ) ?></p>
                    </div>
                    <div class="codesigner-order-date">
                        <h4> <?php echo wp_kses_post( $table_heading_txt_failed ) ?> </h4>
                    </div>
                    <table class="codesigner-product-table">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Product', 'codesigner-pro' ); ?></th>
                                <th><?php esc_html_e( 'Quantity', 'codesigner-pro' ); ?></th>
                                <th><?php esc_html_e( 'Price', 'codesigner-pro' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            foreach ( $items as $item_id => $item_data ) {

                                $product                = $item_data->get_product();
                                $product_title          = $product->get_name();
                                $product_thumbnail_url  = get_the_post_thumbnail_url($product->get_id(), 'thumbnail');
                                $product_quantity       = $item_data->get_quantity();
                                $product_price          = $product->get_price();
                                
                                ?>
                                <tr>
                                    <td>
                                        <table class="cd-email-product">
                                            <tbody>
                                                <tr>
                                                    <td class="cd-product-img">
                                                        <?php printf( "<a href='%1s'><img src='%2s' alt='%3s'></a>",$product_thumbnail_url, $product_thumbnail_url, $product_title ); ?>
                                                    </td>
                                                    <td  class="cd-email-text-left cd-product-name">
                                                        <span><?php esc_html_e( $product_title ); ?></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                    <td><?php esc_html_e( $product_quantity );?></td>
                                    <td><?php echo wc_price( $product_price ); ?></td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                    <table class="codesigner-item-price-table">
                        <tbody>
                            <tr>
                                <td><?php esc_html_e( 'Subtotal :', 'codesigner-pro' ); ?></td>
                                <td><?php echo wc_price( $subtotal  ); ?></td>
                            </tr>
                            <tr>
                                <td><?php esc_html_e( 'Shipping :', 'codesigner-pro' ); ?></td>
                                <td><?php echo wc_price( $shipping_total  ); ?></td>
                            </tr>
                            <?php if ( $tax_total ) : ?>
                                <tr>
                                    <td><?php esc_html_e( 'Tax Total', 'codesigner-pro' ); ?></td>
                                    <td><?php echo wc_price( $tax_total ); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if ( $discount ) : ?>
                                <tr>
                                    <td><?php esc_html_e( 'Discount', 'codesigner-pro' ); ?></td>
                                    <td><?php echo wc_price(' -'. $discount ); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if ( $fees ) : ?>
                                <?php foreach ( $fees as $fee ) : ?>
                                <tr>
                                    <td><?php esc_html_e( $fee->get_name() ); ?></td>
                                    <td><?php echo wc_price( $fee->get_amount() ); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <tr>
                                <td><?php esc_html_e( 'Total :', 'codesigner-pro' ); ?></td>
                                <td><?php echo wc_price( $total ); ?></td>
                            </tr>
                        </tbody>
                    </table>   
                    <div class="cd-billing-and-shipping-address">
                        <table class="cd-shipping-billing-table">
                            <thead>
                                <tr>
                                    <th><?php echo wp_kses_post( $billing_txt ); ?></th>
                                    <th><?php echo wp_kses_post( $shipping_txt ); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <?php echo wp_kses_post( $formatted_shipping_address ); ?>
                                        <p class="cd-email"> <?php esc_html_e( $shipping_email ); ?> </p>
                                    </td>
                                    <td>
                                        <?php echo wp_kses_post( $formatted_billing_address ); ?>
                                        <p class="cd-email"> <?php esc_html_e( $billing_email ); ?> </p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="cd-before-footer-message">
                        <p><?php echo wp_kses_post( $thanks_txt_failed ); ?> </p>
                    </div>
                    <div class="cd-link-area">
                        <p><?php echo wp_kses_post( $footer_failed_text ); ?> </p>
                    </div>
                </td>
                <td class="cd-no-border cd-deafult-bg"></td>
            </tr>
        </tbody>
    </table>
</div>
<?php 
?>