<?php
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class Email_Designer_Widget extends Widget_Base {

	public function get_name() {
		return 'email_designer_widget';
	}

	public function get_title() {
		return esc_html__( 'CoDesigner Email', 'codesigner-pro' );
	}

	public function get_icon() {
		$cd_branding_class = ' wlbi';
		return 'eicon-mail' . $cd_branding_class;
	}

	public function get_categories() {
		return [ 'codesigner' ];
	}

	public function get_keywords() {
		return [ 'email', 'designer', 'template', 'file', 'document', 'design' ];
	}

    protected function register_controls() {
		/**
		 * content section
		 */
		$this->start_controls_section(
			'cd_email_content',
			[
				'label' 	=> __( 'Email', 'codesigner-pro' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'cd_email_type',
			[
				'label'         => esc_html__( 'Select Email Type', 'codesigner-pro' ),
				'type'          => Controls_Manager::SELECT2,
				'label_block'   => true,
				'multiple'      => false,
				'options'       => [
					'admin-new-order'    		=> esc_html__( 'New Order (Admin)', 'codesigner-pro' ),
					'admin-cancelled-order'   	=> esc_html__( 'Cancelled Order (Admin)', 'codesigner-pro' ),
					'admin-failed-order'    	=> esc_html__( 'Failed Order (Admin)', 'codesigner-pro' ),
					'customer-on-hold-order'    => esc_html__( 'On-hold Order', 'codesigner-pro' ),
					'customer-processing-order' => esc_html__( 'Processing Order', 'codesigner-pro' ),
					'customer-completed-order'  => esc_html__( 'Completed Order', 'codesigner-pro' ),
					'customer-refunded-order'   => esc_html__( 'Refunded Order', 'codesigner-pro' ),
					'customer-invoice'  		=> esc_html__( 'Customer Invoice', 'codesigner-pro' ),
					'customer-note'    			=> esc_html__( 'Customer Note', 'codesigner-pro' ),
					'customer-reset-password'   => esc_html__( 'Reset Password', 'codesigner-pro' ),
					'customer-new-account'    	=> esc_html__( 'New Account', 'codesigner-pro' ),
				],
			]
		);

        $this->end_controls_section();

		// load style controls
		$controls = codesigner_get_email_controls_list();
		foreach( $controls as $control ) {
			$args['control-slug'] 	= $control;
			$args['this'] 			= $this;

			codesigner_load_email_template_controls( $args );
		}
	}

    protected function render() {
        $settings           = $this->get_settings_for_display();
        $selected_template  = $settings['cd_email_type'];
		$order_id 			= wcd_is_edit_mode() || wcd_is_preview_mode() ? wcd_get_random_order_id() : wcd_get_current_order_id();
		
		$args 	= array(
			'template-slug' => $selected_template,
			'settings' 		=> $settings,
			'order_id' 		=> $order_id ? $order_id : 0,
		);

        echo codesigner_load_email_template( $args );
    }
}